package CF::Controller::Users;

use Mojo::Base 'Mojolicious::Controller';
use Mojo::Pg::PubSub;
use feature 'signatures';
no warnings qw{ experimental::signatures };

sub me ($c){
    my $user = $c->_get( $c->user->{id} ) // return;
    $c->render(openapi => $c->spec_filter($user->formatted, 'User'));
}

sub ban ($c){
    my $user   = $c->_get( $c->stash->{id} ) // return;
    my $pubsub = Mojo::Pg::PubSub->new(pg => $c->pg);
    my $guard  = $c->schema->txn_scope_guard;

    $user->update({ banned_until => \"now()+'8 hour'", });
    #TODO: ANN

    $pubsub->json('notify')->notify( notify => {
        event   => 'user_banned',
        payload => $c->spec_filter($user->formatted, 'User'),
    });

    $guard->commit;
    $c->render(status => 204, text => '');
}

sub unban ($c){
    my $user   = $c->_get( $c->stash->{id} ) // return;
    my $pubsub = Mojo::Pg::PubSub->new(pg => $c->pg);
    my $guard  = $c->schema->txn_scope_guard;


    $user->update({ banned_until => undef });
    #TODO: ANN

    $pubsub->json('notify')->notify( notify => {
        event   => 'user_unbanned',
        payload => $c->spec_filter($user->formatted, 'User'),
    });

    $guard->commit;
    $c->render(status => 204, text => '');
}

sub _get ($c, $id ) {

    my $user;

    if ( $id =~ /^\d+$/) {
        $user = $c->schema->resultset('User')->find( { id => $id } );
    }
    else {
        $user = $c->schema->resultset('User')->find( { uuid => $id } );
    }

    return $c->error(404, 'User not found') if ! $user;
    return $user;
}

1;
