alter table "users" add "roles" text;
alter table "users" add "jitsi_allowed" bool not null default false;

create table "sockets" (
    "id" varchar(64),
    "ip" inet,
    "user_id" integer,
    "keepalive" timestamp,
    primary key("id")
);
create index "sockets_user_id_idx" on "sockets"("user_id");
create index "sockets_keepalive_idx" on "sockets"("keepalive");

create view "sockets_view" as
    select "sockets".*,
    ("sockets"."keepalive"+'100 s'::interval) > now() as "is_alive",
    "users"."roles" like '%member%' as "is_member"
from "sockets"
left join "users" on ("sockets"."user_id" = "users"."id");
