package CF::Controller::Program;

use Mojo::Base 'Mojolicious::Controller';
use Mojo::Pg::PubSub;
use feature 'signatures';
no warnings qw{ experimental::signatures };

sub entries {
    my $c = shift->openapi->valid_input or return;

    my $entries = $c->schema->resultset('ProgramEntry')->search(
        { is_approved => 't' },
        { order_by => 'number' },
    );

    my @entries = ();

    ENTRY:
    while ( my $entry = $entries->next ) {
        push @entries, $c->spec_filter( {
            $entry->get_columns,
            expected_start_at  => $c->format_timestamp( $entry->start, '%H:%M' ),
            expected_finish_at => $c->format_timestamp( $entry->finish, '%H:%M' ),
        }, 'ProgramScheduleEntry');
    }

    $c->render(openapi => \@entries );
}

sub update ($c) {
    $c->openapi->valid_input or return;

    my $entry = $c->schema->resultset('ProgramEntry')->find( $c->stash->{id} );
    return $c->error(404, 'Program entry not found') if ! $entry;

    my $update = $c->prepare_update_data( $entry, $c->req->json );
    my $pubsub = Mojo::Pg::PubSub->new(pg => $c->pg);
    my $guard  = $c->schema->txn_scope_guard;

    # muze byt jen jeden aktualni bod programu
    if ( $update->{is_live} ) {
        $c->schema->resultset('ProgramEntry')->search({})->update(
            { is_live => 'f' }
        );
    }

    $entry->update( $update );

    $pubsub->json('notify')->notify( notify => {
        event   => 'program_entry_changed',
        payload => {
            id => $entry->id,
            %{ $update },
        }
    });

    $guard->commit;

    $c->render(status => 204, text => '');
}

1;
