create table "events_acl_subjects" (
    "id" integer not null default nextval('uid_seq'),
    "updated" timestamp(0) not null default now(),
    "class" varchar(8) not null,
    "key" text not null,
    "name" text,
    primary key("id"),
    unique("class", "key")
);

create table "events_acl" (
    "id" integer not null default nextval('uid_seq'),
    "event_id" integer not null,
    "subject_id" integer not null,
    "role" text,
    primary key("id"),
    unique("event_id", "subject_id", "role"),
    foreign key ("event_id") references "events" ("id") on update cascade on delete cascade,
    foreign key ("subject_id") references "events_acl_subjects" ("id") on update cascade on delete cascade
);

create view "events_acl_view" as (
    select
        "events_acl"."id",
        "events_acl"."event_id",
        "events_acl_subjects"."class" as "subject_class",
        "events_acl_subjects"."key" as "subject_key",
        "events_acl_subjects"."name" as "subject_name",
        "events_acl"."role"
    from "events_acl"
    join "events_acl_subjects" on ("events_acl"."subject_id" = "events_acl_subjects"."id")
);

