create table "posts" (
    "id" integer not null default nextval('uid_seq'),
    "datetime" timestamp(0) not null default now(),
    "changed" timestamp(0),
    "deleted" timestamp(0),
    "is_archived" bool not null default 'false',
    "user_id" integer not null,
    "program_entry_id" integer,
    "type" integer not null, -- 0 -  "post" | "procedure-proposal"
    "state" integer not null default 0,
    "content" text,
    "ranking_likes" integer not null default 0,
    "ranking_dislikes" integer not null default 0,
    primary key("id")
);

create table "posts_history" (
    "id" integer not null default nextval('uid_seq'),
    "datetime" timestamp(0) not null default now(),
    "post_id" integer not null,
    "user_id" integer not null,
    "content" text,
    primary key("id")
);

create table "posts_ranking" (
    "id" integer not null default nextval('uid_seq'),
    "post_id" integer not null,
    "user_id" integer not null,
    "ranking" integer,
    primary key("id"),
    unique("post_id", "user_id")
);

create view "posts_view" as
select
    "posts".*,
    "posts"."ranking_likes" - "posts"."ranking_dislikes" as "ranking_score",
    "users"."name" as "user_name",
    "users"."main_group_name" as "group_name",
    "users"."username" as "user_username",
    extract(epoch from "users"."banned_until"-now()) > 0 as "user_is_banned"
from posts
join "users" on ("posts"."user_id" = "users"."id")
;
