package CF::Schema::Result::Post;

use strict;
use warnings;

use base 'DBIx::Class::Core';

our $VERSION = 1;

__PACKAGE__->table('posts');

__PACKAGE__->add_columns(
    id => {
        data_type         => 'integer',
        is_auto_increment => 1,
        is_nullable       => 0,
        sequence          => 'uid_seq'
    },
    qw(
        datetime
        changed
        deleted
        is_archived
        user_id
        program_entry_id
        type
        state
        content
        ranking_likes
        ranking_dislikes
    ),
);

__PACKAGE__->set_primary_key('id');

__PACKAGE__->has_one( view => 'CF::Schema::Result::Post_view', 'id');

__PACKAGE__->belongs_to(
    user => 'Zircon::Schema::Result::User',
    {
        'foreign.id' => 'self.user_id',
    },
);

__PACKAGE__->has_many(
    history => 'CF::Schema::Result::PostHistory',
    { 'foreign.post_id' => 'self.id', },
);

__PACKAGE__->has_many(
    rankings => 'CF::Schema::Result::PostRanking',
    { 'foreign.post_id' => 'self.id', },
);

1;
