package CF::Schema::Result::Announcement;

use strict;
use warnings;

use base 'DBIx::Class::Core';

our $VERSION = 1;

__PACKAGE__->table('announcements');

__PACKAGE__->add_columns(
    id => {
        data_type         => 'integer',
        is_auto_increment => 1,
        is_nullable       => 0,
        sequence          => 'uid_seq'
    },
    qw(
        datetime
        deleted
        user_id
        type
        content
        link
        related_post_id
    ),
);

__PACKAGE__->set_primary_key('id');


sub format {
    my $self = shift;

    my $announcement = {
        id              => $self->id,
        datetime        => $self->datetime,
        type            => $self->type,
        content         => $self->content,
        link            => $self->link,
        related_post_id => $self->related_post_id,
    };

    return $announcement;

}

1;
