package CF::Controller::Config;

use Mojo::Base 'Mojolicious::Controller';
use Mojo::Pg::PubSub;
use feature 'signatures';
no warnings qw{ experimental::signatures };

sub entries {
    my $c = shift->openapi->valid_input or return;

    my $entries = $c->schema->resultset('ConfigEntry')->search();

    my @entries = ();

    ENTRY:
    while ( my $entry = $entries->next ) {
        push @entries, $c->spec_filter( {
            $entry->get_columns,
        }, 'ConfigEntry');
    }

    $c->render(openapi => \@entries );
}

sub update ($c) {
    $c->openapi->valid_input or return;

    my $entry = $c->schema->resultset('ConfigEntry')->find( $c->stash->{id} );
    return $c->error(404, 'Config entry not found') if ! $entry;
    return $c->error(403, 'Config entry protected') if $entry->is_readonly;

    my $update = $c->prepare_update_data( $entry, $c->req->json );
    my $pubsub = Mojo::Pg::PubSub->new(pg => $c->pg);
    my $guard  = $c->schema->txn_scope_guard;

    $entry->update( $update );

    $pubsub->json('notify')->notify( notify => {
        event   => 'config_entry_changed',
        payload => {
            id => $entry->id,
            %{ $update },
        }
    });

    $guard->commit;

    $c->render(status => 204, text => '');
}

1;
