package CF::Schema::Result::Event;

use strict;
use warnings;
use feature 'signatures';
no warnings qw{ experimental::signatures };

use base 'DBIx::Class::Core';

our $VERSION = 1;

__PACKAGE__->table('events');

__PACKAGE__->add_columns(
    id => {
        data_type         => 'integer',
        is_auto_increment => 1,
        is_nullable       => 0,
        sequence          => 'uid_seq'
    },
    qw(
        uuid
        type
        state
        owner_id
        is_opened
        is_published
        start
        finish
        deleted
        name
        description
        organizer
        stream_url
    ),
);

__PACKAGE__->belongs_to(
    user => 'CF::Schema::Result::User',
    {
        'foreign.id' => 'self.owner_id',
    },
);

__PACKAGE__->has_many(
    acls => 'CF::Schema::Result::EventACL',
    { 'foreign.event_id' => 'self.id', },
);

__PACKAGE__->set_primary_key('id');

sub format ($self) {

    my $event = {
        id              => $self->id,
        type            => $self->type,
        state           => $self->state,
        is_opened       => $self->is_opened ? \1 : \0,
        is_published    => $self->is_published ? \1 : \0,
        start           => $self->start,
        finish          => $self->finish,
        name            => $self->name,
        description     => $self->description,
        organizer       => $self->organizer,
        stream_url      => $self->stream_url,
    };

### ACL???

    return $event;
}

sub user_roles ($self, $user) {

    return undef if ! $user;

    my $roles = {};

    if ( $self->owner_id == $user->{id} ) {
        $roles->{chairman}  = 1;
    }

    return $roles;
}

1;
