package CF::Controller::Websockets;

use Mojo::Base 'Mojolicious::Controller';
use Mojo::Pg::PubSub;
use feature 'signatures';
no warnings qw{ experimental::signatures };

sub main {
    my $c = shift;

    $c->inactivity_timeout(600);

    my $pubsub = Mojo::Pg::PubSub->new(pg => $c->pg);

    $pubsub->listen(notify => sub($pubsub, $payload) {
        $c->send($payload);
    });

    $c->on(finish => sub ($c, $code, $reason = undef) {
        $pubsub->unlisten('notify');
        $c->app->log->debug("WebSocket closed with status $code");
    });
}

1;
