package CF::Helpers::Core;

use base 'Mojolicious::Plugin';
use feature 'signatures';
no warnings qw{ experimental::signatures } ;

sub register ($class, $self, $conf) {

    $self->helper(error => sub ($c, $status, $errors=[]) {

        if ( scalar @_ == 2 ) {
            $errors = [{ code => shift, message => shift }];
        }
        elsif ( ref $_[0] eq 'ARRAY' ) {
            $errors = shift;
        }
        elsif ( ref $_[0] eq 'HASH' ) {
            $errors = [ shift ];
        }
        else {
            $errors = [{ message => shift, code => undef }];
        }

        $c->stash(
            status  => $status,
            openapi => { errors => $errors }
        );

        return undef;
    });

    $self->helper( trace => sub( $c, $data='' ) {
        $data = Dump $data if ref $data;
        $c->app->log->debug($data);

    });

    $self->helper( spec_filter => sub ($c, $data, $class) {

        if (my $def =$c->openapi->spec("/components/schemas/$class")) {
            my $filtered = {};

            KEY:
            foreach my $key ( keys %{ $def->{properties} } ) {
                my $value    = $data->{$key};
                my $nullable = 0;

                my $types = $def->{properties}{$key}{type};

                if ( ref $types eq 'ARRAY' ) {
                    TYPE:
                    foreach my $type ( @{ $types } ) {
                        $nullable = 1, last if $type eq 'null';
                    }
                }

                $filtered->{$key} = $value;
            }

            $data = $filtered;

        }

        return $data;
    });

    $self->helper( format_timestamp => sub($c, $timestamp, $format) {
        return $timestamp;
    });
}

1;
