package CF::Controller::Program;
use Mojo::Base 'Mojolicious::Controller';

sub entries {
    my $c = shift->openapi->valid_input or return;

    my $entries = $c->schema->resultset('ProgramEntry')->search(
        { is_approved => 't' },
        { order_by => 'number' },
    );

    my @entries = ();

    ENTRY:
    while ( my $entry = $entries->next ) {
        push @entries, $c->spec_filter( {
            $entry->get_columns,
            expected_start_at  => $c->format_timestamp( $entry->start, '%H:%M' ),
            expected_finish_at => $c->format_timestamp( $entry->finish, '%H:%M' ),
        }, 'ProgramScheduleEntry');
    }

    $c->render(openapi => \@entries );
}

1;
