package CF::Helpers::Auth;

use base 'Mojolicious::Plugin';
use feature 'signatures';
no warnings qw{ experimental::signatures };

use Mojo::UserAgent;
use Mojo::JWT;

use constant KEY_FORMAT => "-----BEGIN PUBLIC KEY-----\n%s\n-----END PUBLIC KEY-----";
use constant REGIONS    => qr{^(jhc|jhm|kvk|lbk|msk|olk|pak|pha|plk|stc|ulk|vys|zlk|khk):(f|regp)$};

sub register ( $class, $self, $conf) {

    my $ua  = Mojo::UserAgent->new();
    my ( $jwt, $groups);

    $self->helper( jwt => sub {
        if ( ! $jwt ) {
            my $res;
            eval { $res = $ua->get( $self->cfg->{oauth_url} )->result; };

            if (! $@ && $res->is_success) {
                $jwt = Mojo::JWT->new(
                    public => sprintf( KEY_FORMAT,  $res->json->{public_key} )
                );
            }
        }
        return $jwt;
    });

    $self->helper( oauth_groups => sub ( $c ) {
        if ( ! $groups ) {
            my $res;
            eval { $res = $ua->get( $self->cfg->{groups_url} )->result; };

            if (! $@ && $res->is_success) {
                my $json = $res->json;
                $groups = { map { $_->{code} => $_->{name} } @{ $json } };
            }
        }
        return $groups;
    });

    $self->helper( oauth_token => sub ( $c, $token='' ) {
        $c->stash->{token} //= $token;
        return $c->stash->{token};
    });

    $self->helper( oauth_claims => sub ( $c ) {
        if ( ! $c->stash->{claims}) {
            return undef if ! ($c->jwt && $c->oauth_token);

            my $claims;
            eval { $claims = $c->jwt->decode( $c->oauth_token );  };

            if ( $@ ) {
                $c->app->log->warn("Invalid token ($@)");
            }

             $c->stash->{claims} = $claims;
        }

        return $c->stash->{claims};
    });

    $self->helper( oauth_main_group_name => sub ( $c ) {
        my $claims = $c->oauth_claims // return;

        GROUP:
        foreach my $group ( sort @{ $claims->{groups} } ) {
            return $c->oauth_groups->{ $group } if $group =~ REGIONS;
        }
    });

    $self->helper( user => sub ( $c ) {
        my $claims = $c->oauth_claims // return undef;

        if ( ! $c->stash->{user} ) {
            $c->stash->{user} = {
                uuid     => $claims->{sub},
                username => $claims->{preferred_username},
                name     => $claims->{name},
                main_group_name => $c->oauth_main_group_name(),
            };
        }
        return $c->stash->{user};
    });

    $self->helper( user_roles => sub ( $c ) {
        my @roles = ();

        if ( $c->cfg->{test_x_roles} && $c->req->headers->header('X-Roles')) {
            @roles = split /\W+/, $c->req->headers('X-Roles');
        }
        elsif ( my $claims = $c->oauth_claims ) {
            @roles = @{ $claims->{roles} // [] };
        }

        $c->stash->{user_roles} //= { map { $_ => 1 }  @roles };
        return $c->stash->{user_roles};
    });

    $self->helper( jitsi_token => sub ( $c, $room='*' ) {
        my $claims = $c->oauth_claims // return undef;

        my $jwt = Mojo::JWT->new(
            secret => $c->cfg->{jitsi_token_secret},
            claims => {
                aud  => 'jitsi',
                iss  => 'cf-online',
                sub  => 'meet.jitsi',
                room => $room,
                exp  => time + $c->cfg->{jitsi_token_lifetime},
                context => {
                    user   => {
                        avatar => join ('',
                            $c->cfg->{piratar_base_url},
                            $claims->{preferred_username},
                            '.jpg',
                        ),
                        name   => $claims->{name},
                        email  => $claims->{mail},
                    }
                },
            }
        )->encode;
    });
}

1;

__END__
