# Generated by Django 4.2.4 on 2023-08-20 16:50

import django.db.models.deletion
import django.utils.timezone
import wagtail.contrib.routable_page.models
import wagtail.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("wagtailimages", "0025_alter_image_file_alter_rendition_file"),
        ("wagtailcore", "0083_workflowcontenttype"),
        ("home", "0029_homearticlepage_tags"),
    ]

    operations = [
        migrations.CreateModel(
            name="HomeVideosPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "content",
                    wagtail.fields.RichTextField(
                        blank=True, null=True, verbose_name="Obsah"
                    ),
                ),
            ],
            options={
                "verbose_name": "Rozcestník videí",
            },
            bases=(
                wagtail.contrib.routable_page.models.RoutablePageMixin,
                "wagtailcore.page",
            ),
        ),
        migrations.CreateModel(
            name="HomeVideoPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "author",
                    models.CharField(
                        blank=True,
                        max_length=128,
                        null=True,
                        verbose_name="Jméno autora",
                    ),
                ),
                (
                    "date",
                    models.DateField(
                        default=django.utils.timezone.now,
                        verbose_name="Datum vytvoření",
                    ),
                ),
                ("content", wagtail.fields.RichTextField(verbose_name="Obsah")),
                (
                    "embed_url",
                    models.URLField(
                        help_text="Pro získání adresy zmáčkni tlačítko Sdílet, vyber záložku Embed a zaškrtní zobrazování pouze URL.",
                        verbose_name="URL Embedu",
                    ),
                ),
                (
                    "author_page",
                    models.ForeignKey(
                        blank=True,
                        help_text="Pokud je vybrána stránka, není nutno vyplňovat jméno autora níže.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="home.homepersonpage",
                        verbose_name="Stránka autora",
                    ),
                ),
                (
                    "thumbnail",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="wagtailimages.image",
                        verbose_name="Náhledový obrázek",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                wagtail.contrib.routable_page.models.RoutablePageMixin,
                "wagtailcore.page",
            ),
        ),
    ]
