# Generated by Django 4.2.2 on 2023-08-06 07:51

import django.db.models.deletion
import django.utils.timezone
import wagtail.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("wagtaildocs", "0012_uploadeddocument"),
        ("wagtailcore", "0083_workflowcontenttype"),
        ("home", "0008_remove_homeuniversalpage_perex"),
    ]

    operations = [
        migrations.CreateModel(
            name="HomeDocumentPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "author",
                    models.CharField(
                        blank=True, max_length=128, null=True, verbose_name="Autor"
                    ),
                ),
                (
                    "date",
                    models.DateField(
                        default=django.utils.timezone.now,
                        verbose_name="Datum vytvoření",
                    ),
                ),
                ("content", wagtail.fields.RichTextField(verbose_name="Obsah")),
                (
                    "document",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="wagtaildocs.document",
                    ),
                ),
                ("tags", models.ManyToManyField(to="home.tag", verbose_name="Štítky")),
            ],
            options={
                "verbose_name": "Dokument",
                "ordering": ["-date"],
            },
            bases=("wagtailcore.page",),
        ),
        migrations.CreateModel(
            name="HomeDocumentsPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "content",
                    wagtail.fields.RichTextField(
                        blank=True, null=True, verbose_name="Obsah"
                    ),
                ),
            ],
            options={
                "verbose_name": "Rozcestník dokumentů",
            },
            bases=("wagtailcore.page",),
        ),
        migrations.CreateModel(
            name="HomeEventPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "author",
                    models.CharField(
                        blank=True, max_length=128, null=True, verbose_name="Autor"
                    ),
                ),
                ("content", wagtail.fields.RichTextField(verbose_name="Obsah")),
                (
                    "date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Datum konání"
                    ),
                ),
                (
                    "location",
                    models.CharField(max_length=64, verbose_name="Místo konání"),
                ),
                ("tags", models.ManyToManyField(to="home.tag", verbose_name="Štítky")),
            ],
            options={
                "verbose_name": "Akce",
                "ordering": ["-date"],
            },
            bases=("wagtailcore.page",),
        ),
        migrations.CreateModel(
            name="HomeEventsPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "content",
                    wagtail.fields.RichTextField(
                        blank=True, null=True, verbose_name="Obsah"
                    ),
                ),
            ],
            options={
                "verbose_name": "Rozcestník akcí",
            },
            bases=("wagtailcore.page",),
        ),
        migrations.DeleteModel(
            name="HomeUniversalPage",
        ),
    ]
