# Generated by Django 4.2.2 on 2023-07-24 03:57

import django.db.models.deletion
import django.utils.timezone
import wagtail.blocks
import wagtail.documents.blocks
import wagtail.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("wagtailcore", "0083_workflowcontenttype"),
        ("home", "0006_alter_tag_id"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="homearticlepage",
            options={"ordering": ["-date"], "verbose_name": "Článek"},
        ),
        migrations.AlterModelOptions(
            name="homearticlespage",
            options={"verbose_name": "Rozcestník článků"},
        ),
        migrations.AlterModelOptions(
            name="homepage",
            options={"verbose_name": "Domovká stránka"},
        ),
        migrations.AlterField(
            model_name="homearticlepage",
            name="author",
            field=models.CharField(
                blank=True, max_length=128, null=True, verbose_name="Autor"
            ),
        ),
        migrations.AlterField(
            model_name="homepage",
            name="address",
            field=models.CharField(max_length=128, verbose_name="Sídlo"),
        ),
        migrations.AlterField(
            model_name="homepage",
            name="branch",
            field=models.CharField(max_length=128, verbose_name="Pobočka"),
        ),
        migrations.AlterField(
            model_name="homepage",
            name="documents",
            field=wagtail.fields.StreamField(
                [
                    (
                        "document",
                        wagtail.blocks.StructBlock(
                            [
                                ("name", wagtail.blocks.CharBlock(label="Jméno")),
                                (
                                    "date_added",
                                    wagtail.blocks.DateBlock(
                                        label="Datum přidání", required=False
                                    ),
                                ),
                                (
                                    "page",
                                    wagtail.blocks.PageChooserBlock(
                                        label="Stránka (místo dokumentu)",
                                        required=False,
                                    ),
                                ),
                                (
                                    "file",
                                    wagtail.documents.blocks.DocumentChooserBlock(
                                        label="Dokument", required=False
                                    ),
                                ),
                            ]
                        ),
                    )
                ],
                blank=True,
                null=True,
                use_json_field=True,
                verbose_name="Dokumenty",
            ),
        ),
        migrations.AlterField(
            model_name="homepage",
            name="ds_id",
            field=models.CharField(max_length=128, verbose_name="Datová schránka"),
        ),
        migrations.AlterField(
            model_name="homepage",
            name="email",
            field=models.EmailField(max_length=128, verbose_name="Email"),
        ),
        migrations.AlterField(
            model_name="homepage",
            name="events",
            field=wagtail.fields.StreamField(
                [
                    (
                        "event",
                        wagtail.blocks.StructBlock(
                            [
                                ("name", wagtail.blocks.CharBlock(label="Jméno")),
                                (
                                    "page",
                                    wagtail.blocks.PageChooserBlock(label="Stránka"),
                                ),
                                (
                                    "date",
                                    wagtail.blocks.DateBlock(
                                        label="Datum konání", required=False
                                    ),
                                ),
                                (
                                    "location",
                                    wagtail.blocks.CharBlock(
                                        label="Lokace", required=False
                                    ),
                                ),
                            ]
                        ),
                    )
                ],
                blank=True,
                null=True,
                use_json_field=True,
                verbose_name="Události",
            ),
        ),
        migrations.AlterField(
            model_name="tag",
            name="name",
            field=models.CharField(max_length=32, verbose_name="Jméno"),
        ),
        migrations.CreateModel(
            name="HomeUniversalPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "author",
                    models.CharField(
                        blank=True, max_length=128, null=True, verbose_name="Autor"
                    ),
                ),
                (
                    "date",
                    models.DateField(
                        default=django.utils.timezone.now,
                        verbose_name="Datum vytvoření",
                    ),
                ),
                ("perex", models.TextField(verbose_name="Perex")),
                ("content", wagtail.fields.RichTextField(verbose_name="Obsah")),
                ("tags", models.ManyToManyField(to="home.tag", verbose_name="Štítky")),
            ],
            options={
                "verbose_name": "Univerzální stránka",
                "ordering": ["-date"],
            },
            bases=("wagtailcore.page",),
        ),
    ]
