# Generated by Django 4.2.2 on 2023-07-23 12:14

import django.db.models.deletion
import wagtail.blocks
import wagtail.documents.blocks
import wagtail.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("wagtailcore", "0083_workflowcontenttype"),
    ]

    operations = [
        migrations.CreateModel(
            name="HomeArticlesPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                ("author", models.CharField(verbose_name="Autor")),
                ("perex", wagtail.fields.RichTextField(verbose_name="Perex")),
                ("content", wagtail.fields.RichTextField(verbose_name="Obsah")),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page",),
        ),
        migrations.CreateModel(
            name="HomePage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "heading_text",
                    wagtail.fields.RichTextField(verbose_name="Hlavní text stránky"),
                ),
                (
                    "events",
                    wagtail.fields.StreamField(
                        [
                            (
                                "event",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "name",
                                            wagtail.blocks.CharBlock(label="Jméno"),
                                        ),
                                        ("url", wagtail.blocks.URLBlock(label="URL")),
                                        (
                                            "date",
                                            wagtail.blocks.DateBlock(
                                                label="Datum konání", required=False
                                            ),
                                        ),
                                        (
                                            "location",
                                            wagtail.blocks.CharBlock(
                                                label="Lokace", required=False
                                            ),
                                        ),
                                    ]
                                ),
                            )
                        ],
                        blank=True,
                        null=True,
                        use_json_field=True,
                        verbose_name="Události",
                    ),
                ),
                (
                    "documents",
                    wagtail.fields.StreamField(
                        [
                            (
                                "document",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "name",
                                            wagtail.blocks.CharBlock(label="Jméno"),
                                        ),
                                        (
                                            "date_added",
                                            wagtail.blocks.DateBlock(
                                                label="Datum přidání", required=False
                                            ),
                                        ),
                                        (
                                            "url",
                                            wagtail.blocks.URLBlock(
                                                label="URL (místo dokumentu)",
                                                required=False,
                                            ),
                                        ),
                                        (
                                            "file",
                                            wagtail.documents.blocks.DocumentChooserBlock(
                                                label="Dokument", required=False
                                            ),
                                        ),
                                    ]
                                ),
                            )
                        ],
                        blank=True,
                        null=True,
                        use_json_field=True,
                        verbose_name="Dokumenty",
                    ),
                ),
                (
                    "donation_text",
                    wagtail.fields.RichTextField(verbose_name="Text pro dary"),
                ),
                ("address", models.CharField(verbose_name="Sídlo")),
                ("branch", models.CharField(verbose_name="Pobočka")),
                ("email", models.EmailField(max_length=254, verbose_name="Email")),
                ("ds_id", models.CharField(verbose_name="Datová schránka")),
                (
                    "director",
                    wagtail.fields.StreamField(
                        [
                            (
                                "person",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "name",
                                            wagtail.blocks.CharBlock(label="Jméno"),
                                        ),
                                        (
                                            "position",
                                            wagtail.blocks.TextBlock(
                                                label="Pracovní pozice", required=False
                                            ),
                                        ),
                                        (
                                            "email",
                                            wagtail.blocks.EmailBlock(
                                                label="E-mailová adresa", required=False
                                            ),
                                        ),
                                    ]
                                ),
                            )
                        ],
                        blank=True,
                        null=True,
                        use_json_field=True,
                        verbose_name="Ředitel",
                    ),
                ),
                (
                    "controller",
                    wagtail.fields.StreamField(
                        [
                            (
                                "person",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "name",
                                            wagtail.blocks.CharBlock(label="Jméno"),
                                        ),
                                        (
                                            "position",
                                            wagtail.blocks.TextBlock(
                                                label="Pracovní pozice", required=False
                                            ),
                                        ),
                                        (
                                            "email",
                                            wagtail.blocks.EmailBlock(
                                                label="E-mailová adresa", required=False
                                            ),
                                        ),
                                    ]
                                ),
                            )
                        ],
                        blank=True,
                        null=True,
                        use_json_field=True,
                        verbose_name="Kontrolor",
                    ),
                ),
                (
                    "council_members",
                    wagtail.fields.StreamField(
                        [
                            (
                                "person",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "name",
                                            wagtail.blocks.CharBlock(label="Jméno"),
                                        ),
                                        (
                                            "position",
                                            wagtail.blocks.TextBlock(
                                                label="Pracovní pozice", required=False
                                            ),
                                        ),
                                        (
                                            "email",
                                            wagtail.blocks.EmailBlock(
                                                label="E-mailová adresa", required=False
                                            ),
                                        ),
                                    ]
                                ),
                            )
                        ],
                        blank=True,
                        null=True,
                        use_json_field=True,
                        verbose_name="Správní rada",
                    ),
                ),
                (
                    "volunteers",
                    wagtail.fields.StreamField(
                        [
                            (
                                "person",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "name",
                                            wagtail.blocks.CharBlock(label="Jméno"),
                                        ),
                                        (
                                            "position",
                                            wagtail.blocks.TextBlock(
                                                label="Pracovní pozice", required=False
                                            ),
                                        ),
                                        (
                                            "email",
                                            wagtail.blocks.EmailBlock(
                                                label="E-mailová adresa", required=False
                                            ),
                                        ),
                                    ]
                                ),
                            )
                        ],
                        blank=True,
                        null=True,
                        use_json_field=True,
                        verbose_name="Dobrovolníci",
                    ),
                ),
                (
                    "employees",
                    wagtail.fields.StreamField(
                        [
                            (
                                "person",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "name",
                                            wagtail.blocks.CharBlock(label="Jméno"),
                                        ),
                                        (
                                            "position",
                                            wagtail.blocks.TextBlock(
                                                label="Pracovní pozice", required=False
                                            ),
                                        ),
                                        (
                                            "email",
                                            wagtail.blocks.EmailBlock(
                                                label="E-mailová adresa", required=False
                                            ),
                                        ),
                                    ]
                                ),
                            )
                        ],
                        blank=True,
                        null=True,
                        use_json_field=True,
                        verbose_name="Zaměstnanci",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page",),
        ),
    ]
